(* ::Package:: *)

(* ::Package:: *)

BeginPackage["PropModSemig`"]
(* Authors: 
J. D. D\'{i}az-Ram\'{i}rez <juandios.diaz@uca.es>,
I. Garc\'{i}a-Garc\'{i}a <ignacio.garcia@uca.es>, 
A. S\'{a}nchez-R.-Navarro <alfredo.sanchez@uca.es>, 
A. Vigneron-Tenorio <alberto.vigneron@uca.es>
*)

SetupNormaliz::usage=
  "SetupNormaliz[path2nmz_] sets the path to the program normaliz, wich is needed to compute convex sets."

IsNnProportionallyModularSemigroup::usage=
  "IsNnProportionallyModularSemigroup[mgs_, gaps_] checks if an N^n semigroup, given by its minimal \
generating set (mgs) and the set of gaps, is a proportionally modular semigroup."

Begin["`Private`"]

Normaliz = "";

SetupNormaliz[path2nmz_] := If[! TrueQ @ FileExistsQ @ path2nmz, 
                              Print["file ", path2nmz, " not found."]; Abort[],
                              Normaliz = path2nmz <> " --ext ";
                            ];

Import["basics.m"]

(* From NumericalSgps's RepresentsSmallElementsOfNumericalSemigroup *)
TestSmallElementsOfNS[l__] := Module[{lset, l0, emax, lenl0, i, j, e}, 
  lset = Union[l];
  If[(! lset === l) || !MemberQ[lset, 0], 
    Return[False],
    If[lset === {0}, Return[True]]
  ];
  l0 = Complement[l, {0}];
  emax = Max[l0];
  lenl0 = Length[l0];
  For[i=1, i<=lenl0, i++,
    For[j=1, j<=lenl0, j++,
      e = l0[[i]]+l0[[j]];
      If[e<emax, 
        If[!MemberQ[l, e], Return[False]],
        Break[]
      ]
    ]
  ];
  Return[True]
];    

IsProportionallyModularSemigroupByGaps[gaps_] := Module[
  {k, mgs, AddGenerator, lmgs, arrang, gs, i, a1, b1, a2, b2},
  k = Complement[Range[0, gaps[[Length[gaps]]]+1], gaps];
  If[!TestSmallElementsOfNS[k], Return[{}]];
  If[Union[k]==={0}, Return[{1,1}]];
  mgs = sistemaminimal[Union[k, Range[k[[Length[k]]], k[[Length[k]]]+k[[2]]-1]]];
  Return[IsSemigroupProportionallyModular[mgs]]
];

PMSEquation[p_, q_] := Module[{a1, b1, a2, b2},
  a1 = Denominator[p]; b1 = Numerator[p];                                                                                 
  a2 = Denominator[q]; b2 = Numerator[q];                                                                                 
  Return[{a1*b2,  b1*b2, a1*b2-a2*b1}]                                                                  
];

MinimalIntervals[list_] :=
 Module[{ord = Ordering[list], listord = SortBy[list, ord]},
   (*Print[list];*)
   DeleteDuplicates[listord, IntervalIntersection[Interval[#1], Interval[#2]] === Interval[#1] &]
];

MaximalInterval[p_, q_] := Module[{x, i, i0, e, ph, qh}, 
  i0 = Ceiling[p/(q-p)];
  x = IntervalUnion[Flatten[Table[Interval[{i*p, i*q}],{i,i0}], 1]];
  x = Select[Range[1, i0*q], (Or @@ IntervalMemberQ[x,#])==False &];
  e = Infinity;
  For[i=1, i<=i0, i++, 
    e = Min[e, ((i p-#)/i) &/@ Intersection[x, Range[Ceiling[(i-1) q], Floor[i p]]]];
  ];
  ph = p-e;

  e = Infinity;
  For[i=1, i<i0, i++, 
    e = Min[e, ((#-i q)/i) &/@ Intersection[x, Range[Ceiling[i q], Floor[(i+1) p]]]];
  ];
  qh = q+e;

  Return[{ph, qh}]
];

MaximalInterval[list_] := MaximalInterval[list[[1]], list[[2]]];

list2nmz[list_, filename_]:=Module[{s, dim, n, i},
  n = Length[list];
  If[n==0, Print["list2nmz: bad input list"];Return[]];
  dim=Length[list[[1]]];
  s = OpenWrite[filename];
  WriteString[s, ToString[StringForm["amb_space ``\n", dim+1]]];
  WriteString[s, ToString[StringForm["polytope ``\n", n]]];
  For[i=1, i<= n, i++,
    WriteString[s, StringJoin[Table[ToString[StringForm["`` ", list[[i,t]]]],{t,dim}]]<>"\n"];
  ];
  WriteString[s, "SupportHyperplanes\n"];
  Close[filename];
];

nmzext2list[filename_]:=Module[{ext, n, dim, i, result},
  ext=Import[filename, "Table"];
  If[Length[ext]<2, Print["nmzext2list: invalid contents in ext file ", filename]; Return[]];
  n = ext[[1,1]];
  If[n==0, Return[]];
  dim = ext[[2,1]];
  result={};
  For[i=3,i<= n+2,i++,
    AppendTo[result,ext[[i,1;;dim-1]]];
  ];
  Return[result]
];


eqHyperP[p_, i_, e_] := Expand[(Times @@ p) (i - Plus @@ Table[e[[j]]/p[[j]], {j, Length[p]}])];

tethaL[s_, L_] := Module[{sol, A, B, P, t, k},
  sol = Solve[eqHyperP[L[[All,1]], 1, t*s]==0, t];
  If[sol=={}, Print["Unexpected result: no intersection"]; Return[]];
  A = (t /. sol)[[1]] * s;
  sol = Solve[eqHyperP[L[[All,2]], 1, t*s]==0, t];
  If[sol=={}, Print["Unexpected result: no intersection"]; Return[]];
  B = (t /. sol)[[1]] * s;
  A = Sqrt[Plus @@ (A*A)];
  B = Sqrt[Plus @@ (B*B)];
  P = Sqrt[Plus @@ (s*s)];
  (* r = Solve[P/B <= k <= P/A, k, Integers]; *)
  If[Solve[P/B <= k <= P/A, k, Integers]=={}, 0, 1]
];

kappaL[v_, p_] := Module[{i}, 
  If[eqHyperP[v, 1, p]>=0, 0, (i /. FindInstance[{eqHyperP[v, i, p] >= 0, i>1}, i, Integers])[[1]]-1]
];

gapsByStrip[l_, g_, o_] := Module[{gbs, i, gdup = g},
  gbs = {{}};
  gbs[[1]] = Select[gdup, eqHyperP[l[[All, 1]], 1, #] > 0 &];
  (*Print["P1 ", eqHyperP[l[[All, 1]], 1, #] &/@ gdup];*)
  gdup = Complement[gdup, gbs[[1]]];
  For[i = 2, i <= o, i++,
    AppendTo[gbs, Select[gdup, (eqHyperP[l[[All, 1]], i, #] > 0 && eqHyperP[l[[All, 2]], i - 1, #] < 0) &]];
    (*Print["P",i," ", {eqHyperP[l[[All, 1]], i, #], eqHyperP[l[[All, 2]], i - 1, #]} &/@ gdup];*)
    gdup = Complement[gdup, gbs[[i]]]
  ]; 
  Return[gbs]
];

vset[H_] := Module[{valx},
  If[H=={},{},
    list2nmz[H, $TemporaryDirectory<>"/input.in"];
    Run[Normaliz<>" "<>$TemporaryDirectory<>"/input.in"];
    valx = nmzext2list[$TemporaryDirectory<>"/input.ext"];
    DeleteFile[{$TemporaryDirectory<>"/input.in", 
                $TemporaryDirectory<>"/input.out", $TemporaryDirectory<>"/input.ext"}];
    valx
  ]
];

(* S is expected as a list of lists of gaps *)
alg2[mgs_, gaps_] := Module[
  {
  n,
  tildeL, delta, hatL, overlap,
  base,
  unkp, unkq,
  H,
  skt, k, khatL,
  sysE, sysF,
  bigomg, fstomg,
  T, valx, result
  },
  n = Last[Dimensions[gaps]];
  tildeL = {};
  Block[{l, g, gapsx = Select[gaps, And[Times @@ # == 0, Count[#, 0] == n - 1] &]},
    For[i = 1, i <= n, i++, 
      g = Select[gapsx, #[[i]] != 0 &][[All, i]]; 
      l = IsProportionallyModularSemigroupByGaps[g];
      If[l == Null, 
        Print["Gaps of ", g, " are not from a proportionally modular semigroup"]; 
        Return[]
      ];
      AppendTo[tildeL, MinimalIntervals[l]]
    ]
  ];
  tildeL=Table[Reverse[SortBy[tildeL[[i]], #[[2]]-#[[1]] &]], {i, Length[tildeL]}];
  
  base = IdentityMatrix[n];
  unkp = Table[Symbol["p" <> ToString[i]], {i, n}];
  unkq = Table[Symbol["q" <> ToString[i]], {i, n}];
  delta = Tuples[tildeL];
  hatL = Table[MaximalInterval[#[[1]], #[[2]]] & /@ delta[[t]], {t, Length[delta]}];
  
  While[delta != {},
    tildeL = delta[[1]];
    overlap = Max[Table[Ceiling[tildeL[[t, 1]]/(tildeL[[t, 2]] - tildeL[[t, 1]])], {t, Length[tildeL]}]];
    delta = Delete[delta, 1];
    skt = Select[mgs, tethaL[#, tildeL]==0 &];
    k = Length[skt];
    khatL = Table[kappaL[hatL[[1]][[All,1]], skt[[i]]], {i, k}];
    If[(Times @@ khatL) != 0,
      H = gapsByStrip[tildeL, gaps, overlap];
      If[Length[gaps]==Length[Flatten[H,1]],
        sysE = {};
        sysE = Union[sysE, Function[x, eqHyperP[unkp, 1, x] > 0] /@ vset[H[[1]]]];

        For[i = 2, i <= overlap, i++,
          sysE = Union[sysE, Flatten[Function[x, {eqHyperP[unkp, i, x] > 0, 
                              eqHyperP[unkq, i-1, x] < 0}] /@  vset[H[[i]]], 1]];
        ];
        
        bigomg = Tuples[Table[Range[khatL[[t]]], {t, k}]];
        For[i = 1, i <= n, i++,
          AppendTo[sysE, hatL[[1, i, 1]] < unkp[[i]] <= tildeL[[i, 1]]];
          AppendTo[sysE, tildeL[[i, 2]] <= unkq[[i]] < hatL[[1, i, 2]]];
        ];
        While[bigomg!={},
          fstomg = bigomg[[1]];
          bigomg = Delete[bigomg,1];
          sysF = Flatten[Function[x, {eqHyperP[unkp, 1, x] <= 0, 
                              eqHyperP[unkq, 1, x] >= 0}] /@ Table[skt[[t]]/fstomg[[t]],{t,k}], 1];
          T = FindInstance[Union[sysE, sysF], Flatten[{unkp, unkq}], Reals];
          
          If[T != {}, 
            valx = (unkp /. T)~Join~(unkq /. T);
            valx = Table[{valx[[1,i]],valx[[2, i]]},{i,n}];
            result = Flatten[Table[base[[i]]*# & /@ valx[[i]], {i, n}], 1];
            Return[result]
          ]
        ]
      ]
    ];
    hatL = Delete[hatL, 1];
  ];
  Return[]
];

alg3[mgs_, gaps_] := Module[
  {
  n, t, i, j,
  tildeL, delta, hatL, overlap,
  unkp, unkq, unkmu1, unknu1, unkmu2, unknu2,
  idxne, gapsne, gapsu, mgsparam,
  skt, k, khatL, bigomg, fstomg,
  base, vzerot1n,
  M,
  P, H, Pb, Pm, Pp, iPa, Pa, uPpPm, upVertEq, GammA, GammAp, kk, e, 
  sysE, sysEp, sysF, sysFp, T, valx
  },
  n = Last[Dimensions[gaps]];
  tildeL = {};
  idxne = Table[False, {i, n}];
  Block[{l, g, gapsx},
    gapsx = Select[gaps, And[Times @@ # == 0, Count[#, 0] == n - 1] &];
    For[i = 1, i <= n, i++,
      g = Select[gapsx, #[[i]] != 0 &][[All, i]];
      If[g == {},
        idxne[[i]] = False;
        AppendTo[tildeL, {{1, Infinity}}], 
        l = IsProportionallyModularSemigroupByGaps[g];
        If[l == Null,
          Print["Gaps ", g, " are not from a proportionally modular semigroup"];
          Return[]
        ];
        idxne[[i]] = True;
        AppendTo[tildeL, MinimalIntervals[l]];
      ]
    ]
  ];
  t = Count[idxne, True];
  vzerot1n = 0*Range[n-t];
  If[n == Last[Dimensions[mgs]],
    If[Plus @@ Pick[#, idxne, False] != vzerot1n,
      Print["mgs incorrect input, ", n-t, " axes should have no gaps."];
      Abort[]
    ]; 
    mgsparam = mgs;
    mgs = Pick[#, idxne];
  ];
  tildeL = Pick[tildeL, idxne]; (*~Join~Pick[tildeL, idxne, False];*)
  tildeL = Table[Reverse[SortBy[tildeL[[i]], #[[2]]-#[[1]] &]], {i, Length[tildeL]}];
  delta = Tuples[tildeL];
  gapsne = Pick[#, idxne]~Join~Pick[#, idxne, False] &/@ gaps;
  
  hatL = Table[MaximalInterval[#[[1]], #[[2]]] & /@ delta[[tt]], {tt, Length[delta]}];
  
  base = IdentityMatrix[n];
  unkp = Table[Symbol["p" <> ToString[i]], {i, t}];
  unkq = Table[Symbol["q" <> ToString[i]], {i, t}];
  unkmu1 = Table[Symbol["mu1" <> ToString[i]], {i, t+1, n}];
  unknu1 = Table[Symbol["nu1" <> ToString[i]], {i, t+1, n}];
  unkmu2 = Table[Symbol["mu2" <> ToString[i]], {i, t+1, n}];
  unknu2 = Table[Symbol["nu2" <> ToString[i]], {i, t+1, n}];

  M = Union[Flatten[Table[{1 > unkmu1[[i-t]] >= 0, 1 > unknu1[[i-t]] >= 0, 1 >= unkmu2[[i-t]] > 0, 
                    1 >= unknu2[[i-t]] > 0, unkmu1[[i-t]]+unkmu2[[i-t]] == 1, unknu1[[i-t]]+unknu2[[i-t]] == 1}, 
                    {i, t+1, n}]]];
  
  eqHyperPTau1[p__, nu1__, nu2__, i_, e_] := Module[{teq=Length[p], neq=Length[p]+Length[nu1]}, Expand[(Times @@ p) 
                                (Times @@ nu2) (i - (Plus @@ Table[e[[j]]/p[[j]], {j, teq}]) + 
                                (Plus @@ Table[(nu1[[j-teq]]/(p[[teq]] nu2[[j-teq]])) e[[j]], {j, teq+1, neq}]))]];

  eqHyperPTau2[p__, nu1__, nu2__, i_, e_] := Module[{teq=Length[p], neq=Length[p]+Length[nu1]}, Expand[(Times @@ p) 
                                (Times @@ nu2) (i - (Plus @@ Table[e[[j]]/p[[j]], {j, teq}]) - 
                                (Plus @@ Table[(nu1[[j-teq]]/(p[[teq]] nu2[[j-teq]])) e[[j]], {j, teq+1, neq}]))]];
  While[delta!={},
    tildeL = delta[[1]];
    delta = Delete[delta, 1];
    overlap = Max[Table[Ceiling[tildeL[[tt, 1]]/(tildeL[[tt, 2]] - tildeL[[tt, 1]])], {tt, Length[tildeL]}]];
    
    skt = Select[mgs, tethaL[#, tildeL]==0 &];
    k = Length[skt];
    khatL = Table[kappaL[hatL[[1]][[All,1]], skt[[i]]], {i, k}];
    If[(Times @@ khatL) != 0,
      P = gapsByStrip[tildeL, gapsne, overlap];
      If[Length[gapsne]==Length[Flatten[P,1]],
        H = Table[{}, {tt, overlap}];
        H[[1]] = Select[P[[1]], #[[t+1;;n]]==vzerot1n &][[All,1;;t]];
        
        sysE = {};
        sysE = Union[sysE, Function[x, eqHyperP[unkp[[1;;t]], 1, x] > 0] /@ vset[H[[1]]]];
        
        For[i = 2, i <= overlap, i++,
          H[[i]] = Select[P[[i]], #[[t+1;;n]]==vzerot1n &][[All,1;;t]];
            sysE = Union[sysE, Flatten[Function[x, {eqHyperP[unkp[[1;;t]], i, x] > 0, 
                              eqHyperP[unkq[[1;;t]], i-1, x] < 0}] /@  vset[H[[i]]], 1]];
        ];

        For[i = 1, i <= t, i++,
          AppendTo[sysE, hatL[[1, i, 1]] < unkp[[i]] <= tildeL[[i, 1]]];
          AppendTo[sysE, tildeL[[i, 2]] <= unkq[[i]] < hatL[[1, i, 2]]];
        ];
        gapsu = Select[gapsne, (Plus @@ #[[t+1;;n]])!=0 &];
        sysF = {};
        Pb = Table[{}, {tt, overlap}];
        Pp = Table[{}, {tt, overlap}];
        Pm = Table[{}, {tt, overlap}];
        For[i = 1, i <= overlap, i++,
          Pb[[i]] = Select[P[[i]], (Plus @@ #[[t+1;;n]])!=0 &];
          sysE = Union[sysE, Flatten[Function[x, {eqHyperPTau1[unkq, unkmu1, unkmu2, i-1, x] < 0, 
                            eqHyperPTau2[unkp, unknu1, unknu2, i, x] > 0}] /@ vset[Pb[[i]]]]];
          Pp[[i]]=DeleteDuplicates[Select[Flatten[Outer[Plus, P[[i]], base[[1;;t]], 1], 1], 
                                (Plus @@ #[[t+1;;n]])!=0 && !MemberQ[gapsu, #] &]];
                                  
          sysF = Union[sysF, Function[x, eqHyperPTau2[unkp, unknu1, unknu2, i, x] <= 0] /@ Pp[[i]]];
          Pm[[i]]=DeleteDuplicates[Select[Flatten[Outer[Plus, P[[i]], -base[[1;;t]], 1], 1], 
                                Function[x, AllTrue[x, #>=0 &] && (Plus @@ x[[t+1;;n]])!=0 &&
                                !MemberQ[gapsu, x]][#] &]];

          sysF = Union[sysF, Function[x, eqHyperPTau1[unkq, unkmu1, unkmu2, i-1, x] >= 0] /@ Pm[[i]]];
        ];
        sysEp = Union[M, sysE];
        Pa=Table[{},{i,overlap}];
        For[i=1, i<=overlap, i++,
          If[P[[i]]!={}, 
            uPpPm = Union[Pp[[i]], Pm[[i]]];
            iPa = Union[gapsu, uPpPm];
            Pa[[i]] = Select[Flatten[Outer[Plus, P[[i]], base[[t+1;;n]], 1], 1], 
                                (Plus @@ #[[t+1;;n]])!=0 && !MemberQ[iPa, #] &];
          ]
        ];
        upVertEq = {};
        For[i=1, i<=overlap, i++,
          AppendTo[upVertEq, Table[{eqHyperPTau1[unkq, unkmu1, unkmu2, i-1, Pa[[i, j]]] >= 0, 
             eqHyperPTau2[unkp, unknu1, unknu2, i, Pa[[i, j]]] <= 0}, 
             {j, Length[Pa[[i]]]}]];
        ];
      
        upVertEq=Flatten[upVertEq,1];
        GammA=Tuples[Table[{1,2},{i,Length[upVertEq]}]];
        
        bigomg = Tuples[Table[Range[khatL[[tt]]], {tt, k}]];
        While[bigomg!={},
          fstomg = bigomg[[1]];
          bigomg = Delete[bigomg, 1];
          sysFp = Union[sysEp, sysF, Flatten[Function[x, {eqHyperP[unkp[[1;;t]], 1, x] <= 0, 
                              eqHyperP[unkq[[1;;t]], 1, x] >= 0}] /@ Table[skt[[tt]]/fstomg[[tt]],{tt, k}], 1]];
          GammAp = GammA;
          While[GammAp!={},
            T = FindInstance[Flatten[{sysFp,
                             Table[upVertEq[[fei, GammAp[[1,fei]]]],{fei,Length[GammAp[[1]]]}]
                             }],
                             Flatten[{unkp, unkq, unkmu1, unkmu2, unknu1, unknu2}], Reals];
            GammAp = Delete[GammAp, 1];
            If[T != {}, 
              valx = (unkp /. T)~Join~(unkq /. T)~Join~Riffle[(unkmu1 /. T), (unkmu2 /. T)]
                                ~Join~Riffle[(unknu1 /. T), (unknu2 /. T)];
              Return[Flatten[valx, 1]];
            ]
          ]
        ]
      ]
    ];
    hatL = Delete[hatL, 1];
  ];
  Return[];
];

IsNnProportionallyModularSemigroup[mgs_, gaps_]:=Module[{n, i, gapsx, compx},
  If[Normaliz=="", Print["Please use SetupNormaliz to set the path to Normaliz program."]; Abort[]];
  n = Last[Dimensions[mgs]];
  If[AnyTrue[mgs, Length[#] != n &],
    Print["mgs elements with different dimensions."];
    Return[];
  ];
  n = Last[Dimensions[gaps]];
  If[AnyTrue[gaps, Length[#] != n &],
    Print["gaps elements with different dimensions."];
    Return[];
  ];
  gapsx = Select[gaps, And[Times @@ # == 0, Count[#, 0] == n - 1] &];
  compx = False;
  For[i = 1, i <= n, i++, 
    If[Select[gapsx, #[[i]] != 0 &][[All, i]] == {}, 
      compx = True;
      Break[];
    ]
  ];
  If[compx, alg3[mgs, gaps], alg2[mgs, gaps]]
];

End[]

EndPackage[] 
