(* ::Package:: *)

pertenece[0, _] := True
 
pertenece[x_, {y_}] := Mod[x, y] == 0

pertenece[x_ /; x > 0, {y_, z__}] := 
 pertenece[x, {z}] || pertenece[x - y, {y, z}]
 
pertenece[x_, _] := False /; x < 0

quitarepetidos[{x___, y_, z___, y_, t___}] := 
 quitarepetidos[{x, y, z, t}]
quitarepetidos[L_] := L

sumaei[i_, x_] := ReplacePart[x, x[[i]] + 1, i]

expresiones[x_ /; x > 0, s_] := 
 Module[{expr, l}, 
  l = Length[s]; 
  expr = {}; 
             Do[If[x - s[[i]] >= 0, 
     expr = Union[expr, (sumaei[i, #1] & ) /@ 
                                    
        expresiones[x - s[[i]], s]]]; , {i, 1, l}]; 
  quitarepetidos[expr]]
 
expresiones[x_ /; x < 0, _] := {}
 
expresiones[0, s_] := {Table[0, {Length[s]}]}

en[x_, y_] := Position[y, x] != {}

semiaux[cond_] := Module[
	{x, s, ap, r, m}, 
	x = 1;
	While[Not[cond[x]],x++];
	m=x;
	ap = Join[{m}, Table[0, {m - 1}]];
	x++;
	s={0,m};
	While[en[0, ap],
		(
			r = Mod[x, m] + 1; 
			If[cond[x], s=Join[s, {x}];
			If[ap[[r]]==0,ap[[r]] = x]];
		x++;
		)
	];
	If[m==1,{0,1},s]
]

semigrupo[cond_] := semiaux[cond]

semigrupo[{x__Integer}]:=semiaux[  pertenece[#,{x}] & ] /; GCD[x]==1

semigrupo[p_, q_] := Module[{a1, b1, a2, b2},
  If[p > q, Return[{}]];
  If[IntegerQ[p] && IntegerQ[q], 
    (* Print["Range ", Range[p, q]]; *)
    semigrupo[Range[p, q]],
    a1 = Denominator[p]; b1 = Numerator[p];
    a2 = Denominator[q]; b2 = Numerator[q];
    If[b1*b2==1, {0, 1},
      (* Print[a1*b2, " ", b1*b2, " ", a1*b2-a2*b1]; *)
      semigrupo[(Mod[a1*b2 #, b1*b2] <= (a1*b2-a2*b1) #)&]
    ]
  ]
]


aperyaux[y_,gen:{m_, l__}] :=
  Module[{x, s, ap, r}, 
	x = Min[m,l]; s = {0};
           ap = Join[{y}, Table[0, {y - 1}]];
           While[en[0, ap],
                (r = Mod[x, y] + 1; 
                If[ap[[r]] != 0, 
		s = Join[s, {x}],
                       If[(Or @@ (en[#1, s] & ) /@ (x - gen)),
			(s = Join[s, {x}]; ap[[r]] = x;)
		]
	    ];
                x++;)
	]; 
     ap
]

apery[x_Integer,{y__Integer}]:=ReplacePart[aperyaux[x,{y}],0,1]/; pertenece[x,{y}] && GCD[y]==1

apery[{y__Integer}]:=apery[First[Sort[{y}]],{y}]

aperyaux[y_,cond_] :=
  Module[{x, ap, r}, x = 1; 
    ap = Join[{y}, Table[0, {y - 1}]];
    While[en[0, ap],
     (r = Mod[x, y] + 1;
      If[ap[[r]]==0 && cond[x],
	ap[[r]]=x];  
      x++;)
   ]; 
ap]

apery[x_Integer,cond_]:=ReplacePart[aperyaux[x,cond],0,1]/; cond[x]

frobenius[{m_Integer,x__Integer}]:=Max[apery[m,{m,x}]]-m /; GCD[m,x]==1

(* Basado en el c\[OAcute]digo correspondiente de NumericalSgps *)
frobenius[p_, q_] := Module[{a, b, c, r, s, j},
  If[Denominator[p]*Denominator[q] == 1, Return[frobenius[Range[p, q]]]];
  a = Denominator[p]*Numerator[q]; 
  b = Numerator[p]*Numerator[q]; 
  c = Denominator[p]*Numerator[q]-Denominator[q]*Numerator[p];
  Print[a, ", ", b, ", ", c];
  If[a <= c, Return[-1]];
  a = Mod[a, b];
  If[a == 0, Return[-1]];
  b - If[c == 1, 
    r = (2*b^2+1)/(2*a*b);
    s = (2*b^2-1)/(2*(a-1)*b);
    Min[semigrupo[r, s][[2;;]]],
    If[a > (b+c)/2, a=b+c-a];
    j = Ceiling[a-a/c-a/b+(2*a)/(c*b)];
    While[Mod[j*b, a] + IntegerPart[(j*b)/a]*c <= (c-1)*b+a-c, j++];
    IntegerPart[(j*b)/a] + 1
  ]
]

pseudofrobenius[{m_Integer,x__Integer}]:=With[{ap=apery[m,{m,x}]}, Select[ap,
(And@@(Or[Not[en[#,ap]],#==0]&/@(ap-#)))&]-m] /; GCD[m,x]==1

EH[{s__Integer}]:=Select[pseudofrobenius[{s}],pertenece[2*#,{s}]&]

H[s_] := With[{g = frobenius[s]}, Complement[Range[0, g], semigrupo[s]]]

H[p_, q_] := With[{g = frobenius[p, q]}, Complement[Range[0, g], semigrupo[p, q]]]

FH[s_] := 
  With[{h = H[s]}, 
    Select[h, (Not[MemberQ[h, 2 #]] && Not[MemberQ[h, 3 #]]) &]]

FHM[s_] := With[
		{h = H[s], m = Min[Select[s, # > 0 &]]}, 
                       Select[h, (Not[MemberQ[h, 2 #]] && Not[MemberQ[h, 3 #]] && 
                            Not[MemberQ[h, m + #]]) &
	            ]
	      ]

grafo[n_,s_]:={
	Select[s,(pertenece[n-#,s])&], 
	Select[Flatten[Outer[List,s,s],1],
	(And[pertenece[n-(Apply[Plus,#]),s],Apply[Less,#]])&]
}

componentesconexasaux[{xx___,{x___,a_,y___},yy___,{u___,a_,v___},zz___}]:=
     componentesconexasaux[{xx,{x,a,y,u,v},yy,zz}]
componentesconexasaux[L_]:=L

componentesconexas[{{v__},{l___}}]:=componentesconexasaux[{Sequence@@(List/@ {v}),l}]

relatoresaux[{x_,s_}]:=
	Module[{l},
            l=Length[s];
            If[l>1,Do[
                     Print[ pintaexpr[First[expresiones[x,s[[1]]]], s[[1]]] , " = ",
                     pintaexpr[First[expresiones[x,s[[i]]]], s[[i]]]],
                     {i,2,l}
		]
	]
  ]

relatoresprincipal[gen:{m_,s__},pinta_]:=
    Module[{ap,candidatos},
      ap=apery[m,gen];
      candidatos=quitarepetidos[Flatten[Outer[Plus,ap,gen],1]];
      candidatos=Map[{#,componentesconexas[grafo[#,gen]]}&,candidatos];
      candidatos=Select[candidatos,(Length[First[Rest[#]]]-1!=0)&];
      (*{Plus@@((Length[First[Rest[#]]]-1)&/@candidatos), candidatos}*)
          Print["N. relatores ", Plus@@((Length[First[Rest[#]]]-1)&/@candidatos)];
      Map[relatoresaux[#]&,candidatos];
          If[pinta,Map[pintagrafo[First[#],gen]&,candidatos]];
          candidatos
    ]/;GCD[m,s]==1
             
relatores[gen_,pinta_:False]:=relatoresprincipal[gen,pinta]

sistemaminimal[{y__Integer}]:=Module[{x},x=Select[{y},(#!=0)&];
  If[x=={},Return[{}]];
  If[GCD@@x==1, sistemaminimal2[x],sistemaminimal1[x]]]

sistemaminimal1[{x___Integer, y_Integer, z___Integer}] := sistemaminimal1[{x,
 z}] /;pertenece[y, {x, z}] 

sistemaminimal1[{x__Integer}] := {x} //Sort

sistemaminimal2[{x__Integer}]:=Module[{m,ap}, m=Min[x]; ap=apery[m,{x}]/. 0->m;
  Select[ap, (And@@(Or[Not[en[#,ap]],#==0]&/@(#-ap)))&]] // Sort

sistemaminimal[cond_]:=Module[{m},
  m=1; 
  If[cond[m]===True,Return[{1}]];
  If[cond[m]===False,
  While[Not[cond[m]],m++];
  sistemaminimal[Join[{m},Drop[apery[m,cond],1]]],Print[cond," no parece ser una condici\[OAcute]n"]]
  (*sistemaminimal[Join[{m},Drop[apery[m,cond],1]]]*)
  ] // Sort

quitaelemento[n_Integer,{m_Integer,s__Integer}]:=
With[{ap=(apery[m,{m,s}]/. 0->m)}, sistemaminimal[(ap/. n->(n+m))]]/; n!=m

quitaelemento[n_Integer,{n_Integer,m_Integer,s___Integer}]:= 
 With[{ap=(apery[m,{n,m,s}]/. 0->m)}, 
	sistemaminimal[(ap/. n->n+m)]]

ponelemento[n_Integer,{s__Integer}]:=sistemaminimal[{n,s}]

unsemigrupoirreducible[n_Integer, {}] := 
	Module[{k}, 
		k = 1; While[Mod[n, k] ==0, k++]; 
		unsemigrupoirreducible[n, {k}]
]

unsemigrupoirreducible[n_Integer, {s__Integer}] := 
	Module[{k}, 
		k = Last[{s}] +1; 
		While[pertenece[k, {s}] || pertenece[n, {s, k}], If[k>n+First[{s}],
                       Return[{s}]]; k++;]; 
		unsemigrupoirreducible[n, {s, k}]]

unsemigrupoirreducible[n_Integer]:=unsemigrupoirreducible[n,{}]

hijosirred[{s__}, g_] := Module[{l}, l = candidatosirred[{s}, g];
      (ponelemento[g - #1, quitaelemento[#1, {s}]] & ) /@ l ]

candidatosirred[{s__}, g_] := Select[{s},
     Position[EH[quitaelemento[#1, {s}]], g - #1] != {} & ]

irreducibles[g_Integer] := Module[{A, B, s}, s = unsemigrupoirreducible[g]; A
      = {s}; B = hijosirred[s, g]; While[B != {}, s = First[B]; B = Rest[B];
      If[Position[A, s] == {}, A = Union[A, {s}]; Print[s]; B = Union[B,
      hijosirred[s, g]]]]; A]

irreducible[g_Integer,e_Integer]:= Module[{A, B, s}, s =
      unsemigrupoirreducible[g]; A = {s}; B = hijosirred[s, g]; While[B != {},
      s = First[B]; If[Length[s]<=e,Return[s]];
      B = Rest[B]; If[Position[A, s] == {}, A = Union[A, {s}]; B
      = Union[B, hijosirred[s, g]]]]; A]

IsSemigroupProportionallyModular[{SG__Integer}] := 
 Module[{S = sistemaminimal[{SG}], A, B, C, X, i, j, Int = {}, z, r, 
   cond = 0},
  If[SG == 1, Return[{{1, 1}}]];
  (*A*)If[en[1, EH[S]] == True, A = Join[Delete[EH[S], 1], S], 
   A = Join[EH[S], S]];
  (*B*)B = 
   Flatten[Table[{A[[i]], j}, {i, 1, Length[A]}, {j, 1, A[[i]] - 1}], 
    1];
  (*C*)C = 
   Sort[B, #1[[1]]/#1[[2]] < #2[[1]]/#2[[
         2]] || (#1[[1]]/#1[[2]] == #2[[1]]/#2[[2]] && #1[[1]] < #2[[
          1]]) &];
  z = Length[S] - 1;
  
  
  (*i = 1, PARA LOS SEGMENTOS QUE PARTEN DESDE EL PRINCIPIO*)
  
  r = z;
  X = Table[C[[j, 1]], {j, 1, 1 + r}];
  If[C[[1 + r, 1]]/C[[1 + r, 2]] != 
     C[[1 + r + 1, 1]]/C[[1 + r + 1, 2]] && 
    Sort[DeleteDuplicates[X]] == Sort[S],
   cond++; 
   AppendTo[Int, {C[[1, 1]]/C[[1, 2]], C[[1 + r, 1]]/C[[1 + r, 2]]}], 
   cond];
  j = 1 + r + 1;
  While[(j <= Length[C] - 1) && True == en[C[[j, 1]], S],
   r++;
   AppendTo[X, C[[j, 1]]];
   If[C[[1 + r, 1]]/C[[1 + r, 2]] != 
      C[[1 + r + 1, 1]]/C[[1 + r + 1, 2]] && 
     Sort[DeleteDuplicates[X]] == Sort[S],
    cond++; 
    AppendTo[Int, {C[[1, 1]]/C[[1, 2]], C[[1 + r, 1]]/C[[1 + r, 2]]}],
     cond];
   j++
   ];
  
  (*2 \[LessEqual] i \[LessEqual] Length[C]-Length[S], 
  PARA LOS SEGMENTOS QUE PARTEN DE ELEMENTOS INTERIORES*)
  Clear[j]; 
  Clear[r];
  For[i = 2, i <= Length[C] - Length[S], i++, r = z;
   X = Table[C[[j, 1]], {j, i, i + r}];
   If[C[[i - 1, 1]]/C[[i - 1, 2]] != C[[i, 1]]/C[[i, 2]] && 
     C[[i + r, 1]]/C[[i + r, 2]] != 
      C[[i + r + 1, 1]]/C[[i + r + 1, 2]] && 
     Sort[DeleteDuplicates[X]] == Sort[S],
    cond++; 
    AppendTo[Int, {C[[i, 1]]/C[[i, 2]], C[[i + r, 1]]/C[[i + r, 2]]}],
     cond];
   j = i + r + 1;
   While[(j <= Length[C] - 1) && True == en[C[[j, 1]], S],
    r++;
    AppendTo[X, C[[j, 1]]];
    If[C[[i - 1, 1]]/C[[i - 1, 2]] != C[[i, 1]]/C[[i, 2]] && 
      C[[i + r, 1]]/C[[i + r, 2]] != 
       C[[i + r + 1, 1]]/C[[i + r + 1, 2]] && 
      Sort[DeleteDuplicates[X]] == Sort[S],
     cond++; 
     AppendTo[
      Int, {C[[i, 1]]/C[[i, 2]], C[[i + r, 1]]/C[[i + r, 2]]}], 
     cond];
    j++
    ]
   ];
  
  
  (*i = Length[C]-r, PARA EL \[CapitalUAcute]LTIMO SEGMENTO DE IZQUIERDA A DERECHA*)

    X = Table[C[[j, 1]], {j, Length[C] - z, Length[C]}];
  If[C[[Length[C] - z - 1, 1]]/C[[Length[C] - z - 1, 2]] != 
     C[[Length[C] - z, 1]]/C[[Length[C] - z, 2]] && 
    Sort[DeleteDuplicates[X]] == Sort[S],
   cond++; 
   AppendTo[
    Int, {C[[Length[C] - z, 1]]/C[[Length[C] - z, 2]], 
     C[[Length[C], 1]]/C[[Length[C], 2]]}], cond];
  
  
  (*PARA LOS SEGMENTOS QUE TERMINAN EN EL \[CapitalUAcute]LTIMO ELEMENTO C[[i,1]], 
  DE DERECHA A IZQUIERDA*)
  Clear[j]; Clear[r];
  r = z;
  X = Table[C[[j, 1]], {j, Length[C] - r, Length[C]}];
  If[C[[Length[C] - r - 1, 1]]/C[[Length[C] - r - 1, 2]] != 
     C[[Length[C] - r, 1]]/C[[Length[C] - r, 2]] && 
    Sort[DeleteDuplicates[X]] == Sort[S],
   cond++; 
   AppendTo[
    Int, {C[[Length[C] - r, 1]]/C[[Length[C] - r, 2]], 
     C[[Length[C], 1]]/C[[Length[C], 2]]}], cond];
  j = Length[C] - r - 1;
  While[(j >= 2) && True == en[C[[j, 1]], S],
   r++;
   AppendTo[X, C[[j, 1]]];
   If[C[[Length[C] - r - 1, 1]]/C[[Length[C] - r - 1, 2]] != 
      C[[Length[C] - r, 1]]/C[[Length[C] - r, 2]] && 
     Sort[DeleteDuplicates[X]] == Sort[S],
    cond++; 
    AppendTo[
     Int, {C[[Length[C] - r, 1]]/C[[Length[C] - r, 2]], 
      C[[Length[C], 1]]/C[[Length[C], 2]]}], cond];
   j--
   ];
  
  
  (*PARA EL SEGMENTO QUE CONTIENE A TODOS LOS ELEMENTOS C[[j,1]], 
  principalmente para S=<2,3>*)
  
  X = Table[C[[j, 1]], {j, 1, Length[C]}];
  If[Sort[DeleteDuplicates[X]] == Sort[S],
   cond++; 
   AppendTo[
    Int, {C[[1, 1]]/C[[1, 2]], C[[Length[C], 1]]/C[[Length[C], 2]]}], 
   cond];
  
  
  (*PARA VER SI EL S.N. ES PROP. MODULAR *)
  
  If[cond == 0, Print["S IS NOT proportionally modular"],
   (* Print["S IS proportionally modular and the interval(s) that \
generate(s) it is(are): ", DeleteDuplicates[Int]]; *)
   Return[DeleteDuplicates[Int]];
   ]
  ]
